﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Data.Linq;
using System.Net;
using System.Security.Cryptography.X509Certificates;
using System.Threading;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{

    public class AHOBPRShared : AHOBPRBaseBO
    {
        //Predefined Registry Flag Ids
        public enum PredefinedAdminFlag
        {
            ReviewToEligible = 1,
            ReviewToReviewNotEligible = 2,
            NotEligibleToEligible = 3,
            NotEligibleToReviewNotEligible = 4,
            ReviewNotEligibleToEligible = 5,
            ReviewNotEligibleToReviewNotEligible = 6,
            ParticipantToEligible = 7,
            ParticipantToReviewNotEligible = 8,
            NoConsentToEligible = 9,
            NoConsentToReviewNotEligible = 10,
            ConsentToEligible = 11,
            ConsentToReviewNotEligible = 12,
            EligibleToEligible = 13,
            EligibleToReviewNotEligible = 14,
            ReviewHEC = 15
        }

        public enum DeploymentStage
        {
            New = 1,
            NotEligible = 2,
            Verified = 3,
            Refuted = 4,
            Accepted = 5,
            Rejected = 6
        }

        public enum HeathFactorCategory
        {
            ChiefComplaint = 1,
            ExposureConcerns = 2,
            Asthma = 3,
            SmokingDuringDeployment = 4,
            Tobacco = 5,
            BirthDefects = 6,
            Abnormalities = 7,
            Orders = 8
        }

        public static int ERROR_LOG_EVENT_ID = 8246;

        public static int GetRegistryID()
        {
            int id = 0;

            if (AHOBPRGlobal.AhobprRegistryId > 0)
            {
                id = AHOBPRGlobal.AhobprRegistryId;
            }
            else
            {
                using (_dbRegistry = GetRegistryDataContext())
                {
                    AHOBPRGlobal.AhobprRegistryId = (from e in _dbRegistry.STD_REGISTRies
                                                     where e.CODE == AHOBPRGlobal.AhobprRegistryCode
                                                     select e.ID).FirstOrDefault();
                    id = AHOBPRGlobal.AhobprRegistryId;
                }
            }

            return id;
        }

        public static int GetStdBranchOfServiceId(string branchOfService)
        {
            int id = 0;

            switch (branchOfService.ToLower())
            {
                case "a":
                case "army":
                case "army nurse corps":
                    id = (int)Enums.BranchOfService.Army;
                    break;
                case "f":
                case "air force":
                    id = (int)Enums.BranchOfService.AirForce;
                    break;
                case "n":
                case "navy":
                    id = (int)Enums.BranchOfService.Navy;
                    break;
                case "m":
                case "marine corps":
                case "marines":
                    id = (int)Enums.BranchOfService.MarineCorps;
                    break;
                case "c":
                case "cg":
                case "coast guard":
                    id = (int)Enums.BranchOfService.CoastGuard;
                    break;
                case "h":
                case "public health service":
                    id = (int)Enums.BranchOfService.PublicHealthService;
                    break;
                default:
                    id = (int)Enums.BranchOfService.Uknown;
                    break;
            }

            return id;
        }

        public static int GetStdComponent(String component)
        {
            if(String.IsNullOrEmpty(component))
            {
                component = "";
            }
            component = component.ToLower();
            int compoId = (int)Enums.Compo.NoDataAvailable;
            switch (component)
            {
                case "a":
                    compoId = (int)Enums.Compo.ActiveDuty;
                    break;
                case "activeduty":
                    compoId = (int)Enums.Compo.ActiveDuty;
                    break;
                case "v":
                    compoId = (int)Enums.Compo.GuardReserve;
                    break;
                case "guardreserve":
                    compoId = (int)Enums.Compo.GuardReserve;
                    break;
                case "n":
                    compoId = (int)Enums.Compo.NationalGuard;
                    break;
                case "nationalguard":
                    compoId = (int)Enums.Compo.NationalGuard;
                    break;
                case "r":
                    compoId = (int)Enums.Compo.Retiree;
                    break;
                case "retiree":
                    compoId = (int)Enums.Compo.Retiree;
                    break;
                case "q":
                    compoId = (int)Enums.Compo.ReserveRetiree;
                    break;
                case "reserveretiree":
                    compoId = (int)Enums.Compo.ReserveRetiree;
                    break;
                default:
                    compoId = (int)Enums.Compo.NoDataAvailable;
                    break;
            }
            return compoId;
        }

        public bool LogErrorMessage(string errorType, string errorSource, string errorMessage)
        {
            return AHOBPRLogger.LogErrorMessage(errorType, errorSource, errorMessage);
        }

        public static int GetUserRoleId(string roleCode)
        {
            int id = 0;

            switch (roleCode)
            {
                case AHOBPRGlobal.AhobprUserRoleRegistryManagerCode:
                    if (AHOBPRGlobal.AhobprUserRoleRegistryManagerId > 0)
                    {
                        id = AHOBPRGlobal.AhobprUserRoleRegistryManagerId;
                    }
                    else
                    {
                        using (_dbRegistry = GetRegistryDataContext())
                        {
                            AHOBPRGlobal.AhobprUserRoleRegistryManagerId = (from e in _dbRegistry.STD_ROLEs
                                                                            where e.CODE == AHOBPRGlobal.AhobprUserRoleRegistryManagerCode
                                                                            select e.ID).FirstOrDefault();
                            id = AHOBPRGlobal.AhobprUserRoleRegistryManagerId;
                        }
                    }
                    break;
                case AHOBPRGlobal.AhobprUserRoleAdvancedUserCode:
                    if (AHOBPRGlobal.AhobprUserRoleAdvancedUserId > 0)
                    {
                        id = AHOBPRGlobal.AhobprUserRoleAdvancedUserId;
                    }
                    else
                    {
                        using (_dbRegistry = GetRegistryDataContext())
                        {
                            AHOBPRGlobal.AhobprUserRoleAdvancedUserId = (from e in _dbRegistry.STD_ROLEs
                                                                         where e.CODE == AHOBPRGlobal.AhobprUserRoleAdvancedUserCode
                                                                         select e.ID).FirstOrDefault();
                            id = AHOBPRGlobal.AhobprUserRoleAdvancedUserId;
                        }
                    }
                    break;
                case AHOBPRGlobal.AhobprUserRoleCareTeamCode:
                    if (AHOBPRGlobal.AhobprUserRoleCareTeamId > 0)
                    {
                        id = AHOBPRGlobal.AhobprUserRoleCareTeamId;
                    }
                    else
                    {
                        using (_dbRegistry = GetRegistryDataContext())
                        {
                            AHOBPRGlobal.AhobprUserRoleCareTeamId = (from e in _dbRegistry.STD_ROLEs
                                                                     where e.CODE == AHOBPRGlobal.AhobprUserRoleCareTeamCode
                                                                     select e.ID).FirstOrDefault();
                            id = AHOBPRGlobal.AhobprUserRoleCareTeamId;
                        }
                    }
                    break;
            }

            return id;

        }

        public static INTERFACE_CALL_LOG GetLatestInterfaceCallLog(String registrantId)
        {
            INTERFACE_CALL_LOG log = null;
            int registrantIdAsInt = -1;
            int.TryParse(registrantId, out registrantIdAsInt);

            using (_dbAhobpr = GetDataContext())
            {
                log = (from l in _dbAhobpr.INTERFACE_CALL_LOGs
                        where l.REGISTRANT_ID == registrantIdAsInt
                        orderby l.TIME_OF_CALL descending
                        select l).FirstOrDefault();
            }

            return log;
        }

        public static byte[] GetDasPdf(String registrantId)
        {
            byte[] bytes = new byte[0];
            try
            {
            INTERFACE_CALL_LOG logEntry = GetLatestInterfaceCallLog(registrantId);
            String blu = FindBlu(logEntry.RETURN_VALUES);

            String uri = System.Configuration.ConfigurationManager.AppSettings["DasUri"];
            uri = uri.Replace("core/AirborneHazardsAndOpenBurnPitRegistrySelfAssessmentQuestionnaires/transform", "core/fs/" + blu);
            HttpWebRequest webRequest = (HttpWebRequest)WebRequest.Create(new Uri(uri));
            //Add Certificates
            X509Certificate certificate = GetCert(System.Configuration.ConfigurationManager.AppSettings["AhobprDasCert"]);
            if (certificate != null)
            {
                webRequest.ClientCertificates.Add(certificate);
            }

            WebResponse response = webRequest.GetResponse();
            System.IO.StreamReader reader = new System.IO.StreamReader(response.GetResponseStream());
            String responseString = reader.ReadToEnd();
            

            bytes = System.Text.Encoding.UTF8.GetBytes(responseString);
            }
            catch (Exception ex)
            {
                bytes = System.Text.Encoding.UTF8.GetBytes("Error: " + ex.Message);
            }
            return bytes;
        }

        private static X509Certificate2 GetCert(String subjectName)
        {
            X509Store store = new X509Store(StoreName.My, StoreLocation.LocalMachine);
            store.Open(OpenFlags.ReadOnly);
            X509Certificate2Collection certificateCollection =
                store.Certificates.Find(X509FindType.FindBySubjectName, subjectName, false);
            if (certificateCollection.Count > 0)
            {
                return certificateCollection[0];
            }
            return null;
        }

        private static String FindBlu(String json)
        {
            /*
  {"BinaryLocationUri": "2015067346145e29adb157ed9dc296eac9671350", 
  "ObjectID": "$ObjectID(5582e62c2a0c0a725517d14b)", 
  "ConversationID": "d0432ab8-9be5-457b-880f-948bda3c9997"}*/

            String[] tokens = json.Split('"');
            for (int i = 0; i < tokens.Length; i++)
            {
                if (tokens[i] == "BinaryLocationUri")
                {
                    return tokens[i + 2];
                }
            }
            return "";
        }
    }
}
